<?php
/*
	Stempora Web Framework
	Copyright (c) 2002-2018 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com				
*/


/**
* description
*
* @library	
* @author	
* @since	
*/
class CAuthBackend extends CPlugin{


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function readUserAcl($user) {

		if ($user["user_groups"]) {

			$groups = $this->db->QFetchRowArray("
				SELECT 
					* 
				FROM 
					{$this->tables['users_groups']}
				WHERE
					group_id IN ({$user[user_groups]})
				");
	
			if (is_Array($groups)) {
				foreach ($groups as $key => $val) {

					if ($val["group_viewonly"]) {
						return "viewonly";
					}

					if ($val["group_superadmin"]) {
						return "superadmin";
					}					
				}				
			}

			$acl = $this->db->QFetchRowArray("
				SELECT 
					* 
				FROM
					{$this->tables['users_acl']}
				WHERE
					acl_group IN ($user[user_groups])
				"
			);

			if (is_array($acl)) {

				foreach ($acl as $key => $val) {

					$_acl[] = array(
						"code"	=> $val["acl_code"],
						"mod"	=> $val["acl_mod_id"] ? $val["acl_mod_id"] : $val["acl_module"]
					);
				}				
			}						
		}

		return $_acl;
		
	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function GenerateAutoLogin($user) {

		$this->db->QueryInsert(
			$this->tables["users_autologin"],
			$data = array(
				"sess_date"		=> time(),
				"user_id"		=> $user["user_id"],
				"sess_token"	=> hash('sha256',openssl_random_pseudo_bytes(50))
			)
		);


		$time = time()+3600 *24 * 3600 ; // one year ahead
		setcookie("autologin", "true", $time);  
		setcookie("username", $user["user_login"], $time);  
		setcookie("keycode" , $data["sess_token"], $time);
	}
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function AutoLogin() {
		global $_SESS;

		if (is_array($_SESS["minibase"])) {
			return false;
		}
		
		$user = $this->db->QFetchArray("SELECT * FROM {$this->tables['users']} WHERE user_login LIKE '%s' AND user_status=1" , array($_COOKIE["username"]));

		if (!is_array($user)) {
			return false;
		}

		//check for the autologin key
		$autologin = $this->db->QFetchArray("SELECT * FROM {$this->tables['users_autologin']} WHERE user_id={$user[user_id]} AND sess_token LIKE '%s'" , array($_COOKIE["keycode"]));


		if (!is_array($autologin)) {
			return false;
		}
		
		//check if its the user user
		if ($autologin["user_id"] != $user["user_id"]) {
			return false;
		}

		//all seems to be ok save the user in the session		
		$user["acl"] = $this->readUserAcl($user);

		$_SESS["minibase"]["tries"] = 0;
		$_SESS["minibase"]["user"] = 1;
		$_SESS["minibase"]["raw"] = $user;


		//invalidate the current key
		$this->db->Query("DELETE FROM {$this->tables['users_autologin']} WHERE sess_id=%d" , array($autologin["sess_id"]));

		//generate a new key
		$this->GenerateAutoLogin($user);

		header('Location: '.$_SERVER['REQUEST_URI']);
		exit;

		debug($_GET,1);
		return true;

	}

	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function forceInit() {
		global $site;

		$this->db = &$site->db;

		//initialize only the needed tables
		$this->tables = array(
			"users"				=> "site_users",
			"users_autologin"	=> "site_users_autologin",
			"users_acl"			=> "site_users_acl",
			"users_groups"		=> "site_users_groups",
		);//&$site->tables;
	}
	
}
